import 'package:flutter/material.dart';

class StyledContainer extends StatelessWidget {
  const StyledContainer({
    super.key,
    required this.child,
    this.borderWidth = 20,
    this.borderRadius = 6,
    this.depth = 7,
    this.lowerColor,
    this.upperColor,
  });

  final Widget child;
  final double borderWidth;
  final double borderRadius;
  final int depth;
  final Color? lowerColor;
  final Color? upperColor;

  Widget nestedContainers({
    required Widget child,
    required int containerDepth,
    required Color lowerColor,
    required Color upperColor,
  }) {
    final double singleBorderWidth = borderWidth / depth;
    final Color borderColor =
        Color.lerp(upperColor, lowerColor, (containerDepth / depth - 0.5).abs() * 2) ??
            Colors.white;

    final double radius = borderRadius + borderRadius * (containerDepth / depth);

    return Container(
      decoration: BoxDecoration(
        color: borderColor,
        border: Border.all(
          color: borderColor,
          width: singleBorderWidth,
        ),
        borderRadius: BorderRadius.circular(radius),
      ),
      child: containerDepth == 0
          ? Padding(
              padding: const EdgeInsets.all(8),
              child: child,
            )
          : nestedContainers(
              child: child,
              containerDepth: containerDepth - 1,
              lowerColor: lowerColor,
              upperColor: upperColor,
            ),
    );
  }

  @override
  Widget build(BuildContext context) {
    return nestedContainers(
      child: child,
      containerDepth: depth,
      lowerColor: lowerColor ?? Theme.of(context).colorScheme.surface,
      upperColor: upperColor ?? Theme.of(context).colorScheme.onSurface,
    );
  }
}
