import 'package:flutter/material.dart';

class ShowDebugWidget extends StatelessWidget {
  const ShowDebugWidget({
    super.key,
    required this.content,
  });

  final String content;

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        color: Colors.red,
        border: Border.all(
          color: Colors.grey,
          width: 2,
        ),
      ),
      child: Padding(
        padding: const EdgeInsets.all(5),
        child: Text(
          content,
          textAlign: TextAlign.start,
          style: const TextStyle(fontSize: 13),
        ),
      ),
    );
  }
}
