import 'package:easy_localization/easy_localization.dart';
import 'package:flutter/material.dart';

class AppHeader extends StatelessWidget {
  const AppHeader({super.key, required this.text});

  final String text;

  @override
  Widget build(BuildContext context) {
    return Text(
      tr(text),
      textAlign: TextAlign.start,
      style: Theme.of(context).textTheme.headlineMedium!.apply(fontWeightDelta: 2),
    );
  }
}

class AppTitle extends StatelessWidget {
  const AppTitle({super.key, required this.text});

  final String text;

  @override
  Widget build(BuildContext context) {
    return Text(
      tr(text),
      textAlign: TextAlign.start,
      style: Theme.of(context).textTheme.titleLarge!.apply(fontWeightDelta: 2),
    );
  }
}
