import 'package:flutter/material.dart';

import 'package:flutter_custom_toolbox/utils/color_extensions.dart';

class OutlinedText extends StatelessWidget {
  const OutlinedText({
    super.key,
    required this.text,
    required this.fontSize,
    required this.textColor,
    this.outlineColor,
  });

  final String text;
  final double fontSize;
  final Color textColor;
  final Color? outlineColor;

  @override
  Widget build(BuildContext context) {
    final double delta = fontSize / 30;

    return Text(
      text,
      style: TextStyle(
        inherit: true,
        fontSize: fontSize,
        fontWeight: FontWeight.w600,
        color: textColor,
        shadows: [
          Shadow(
            offset: Offset(-delta, -delta),
            color: outlineColor ?? textColor.darken(),
          ),
          Shadow(
            offset: Offset(delta, -delta),
            color: outlineColor ?? textColor.darken(),
          ),
          Shadow(
            offset: Offset(delta, delta),
            color: outlineColor ?? textColor.darken(),
          ),
          Shadow(
            offset: Offset(-delta, delta),
            color: outlineColor ?? textColor.darken(),
          ),
        ],
      ),
    );
  }
}
