import 'package:flutter/material.dart';

import 'package:flutter_custom_toolbox/flutter_toolbox.dart';

part 'application_theme_mode_state.dart';

class ApplicationThemeModeCubit extends HydratedCubit<ApplicationThemeModeState> {
  ApplicationThemeModeCubit() : super(const ApplicationThemeModeState());

  void getTheme(ApplicationThemeModeState state) {
    emit(state);
  }

  @override
  ApplicationThemeModeState? fromJson(Map<String, dynamic> json) {
    switch (json['themeMode']) {
      case 'ThemeMode.dark':
        return const ApplicationThemeModeState(themeMode: ThemeMode.dark);
      case 'ThemeMode.light':
        return const ApplicationThemeModeState(themeMode: ThemeMode.light);
      case 'ThemeMode.system':
      default:
        return const ApplicationThemeModeState(themeMode: ThemeMode.system);
    }
  }

  @override
  Map<String, String>? toJson(ApplicationThemeModeState state) {
    return <String, String>{'themeMode': state.themeMode.toString()};
  }
}
