import 'package:flutter/material.dart';

import 'package:flutter_custom_toolbox/flutter_toolbox.dart';

part 'settings_activity_state.dart';

class ActivitySettingsCubit extends HydratedCubit<ActivitySettingsState> {
  final ApplicationConfigDefinition appConfig;

  ActivitySettingsCubit({
    required this.appConfig,
  }) : super(
          ActivitySettingsState(
            settings: ActivitySettings.createDefault(
              appConfig: appConfig,
            ),
          ),
        );

  void setValues({
    Map<String, String>? values,
  }) {
    emit(
      ActivitySettingsState(
        settings: ActivitySettings(
          appConfig: appConfig,
          values: values ?? state.settings.values,
        ),
      ),
    );
  }

  String get(String code) {
    return state.settings.get(code);
  }

  void set(String code, String value) {
    Map<String, String> values = state.settings.values;

    values[code] = value;

    setValues(
      values: values,
    );
  }

  @override
  ActivitySettingsState? fromJson(Map<String, dynamic> json) {
    Map<String, String> values = {};

    json.forEach((key, value) {
      values[key] = value as String;
    });

    return ActivitySettingsState(
      settings: ActivitySettings(
        appConfig: appConfig,
        values: values,
      ),
    );
  }

  @override
  Map<String, dynamic>? toJson(ActivitySettingsState state) {
    return state.settings.values;
  }
}
