import 'package:flutter/material.dart';
import 'package:flutter_custom_toolbox/flutter_toolbox.dart';

class GlobalAppBar extends StatelessWidget implements PreferredSizeWidget {
  const GlobalAppBar({
    super.key,
    required this.appConfig,
    required this.pageIndex,
    required this.isActivityRunning,
  });

  final ApplicationConfigDefinition appConfig;
  final int pageIndex;
  final bool isActivityRunning;

  @override
  Widget build(BuildContext context) {
    final bool displayQuitActivityButton =
        !(appConfig.navigation.appBarConfiguration?.hideQuitActivityButton ?? false);

    final bool pushQuitActivityButtonLeft =
        (appConfig.navigation.appBarConfiguration?.pushQuitActivityButtonLeft == true);

    final bool showApplicationTitle =
        !(appConfig.navigation.appBarConfiguration?.hideApplicationTitle ?? false);

    final List<AppBarButton> Function(BuildContext context) builder =
        appConfig.navigation.appBarConfiguration?.topBarButtonsBuilder ??
            // Default top bar buttons
            (BuildContext context) {
              if (isActivityRunning) {
                return <AppBarButton>[];
              }

              return <AppBarButton>[
                // Go to About page
                AppBarButton(
                  onPressed: (BuildContext context) =>
                      BlocProvider.of<NavCubitScreen>(context).goToScreenAbout(),
                  icon: appConfig.navigation.screenAbout.icon,
                ),

                // Go to Settings page
                AppBarButton(
                  onPressed: (BuildContext context) =>
                      BlocProvider.of<NavCubitScreen>(context).goToScreenSettings(),
                  icon: appConfig.navigation.screenSettings.icon,
                ),

                // Back to Home page
                AppBarButton(
                  onPressed: (BuildContext context) =>
                      BlocProvider.of<NavCubitScreen>(context).goToScreenActivity(),
                  icon: appConfig.navigation.screenActivity.icon,
                ),
              ];
            };

    final List<Widget> menuActions = [];

    // left pushed "quit activity" button
    if (isActivityRunning && displayQuitActivityButton && pushQuitActivityButtonLeft) {
      menuActions.add(ActivityButtonQuit(
        onPressed: () {},
        onLongPress: () => appConfig.quitCurrentActivity(context),
      ));

      menuActions.add(const Spacer(flex: 6));
    }

    // add buttons
    final List<AppBarButton> buttons = builder(context);
    for (AppBarButton button in buttons) {
      menuActions.add(button.render(context));
    }

    // standard right pushed "quit activity" button
    if (isActivityRunning && displayQuitActivityButton && !pushQuitActivityButtonLeft) {
      menuActions.add(ActivityButtonQuit(
        onPressed: () {},
        onLongPress: () => appConfig.quitCurrentActivity(context),
      ));
    }

    return AppBar(
      title: showApplicationTitle ? const AppHeader(text: 'app_name') : null,
      actions: menuActions,
    );
  }

  @override
  Size get preferredSize => const Size.fromHeight(50);
}
